using System;
using System.Globalization;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;


namespace CSharpRecipes
{
	public class StringsAndChars
    {
        #region "2.1 Okrelenie rodzaju znaku w zmiennej char"
        public static CharKind GetCharKind(char theChar)
		{
			if (Char.IsControl(theChar))
			{
				return CharKind.Control;
			}
			else if (Char.IsDigit(theChar))
			{
				return CharKind.Digit;
			}
			else if (Char.IsLetter(theChar))
			{
				return CharKind.Letter;
			}
			else if (Char.IsNumber(theChar))
			{
				return CharKind.Number;
			}
			else if (Char.IsPunctuation(theChar))
			{
				return CharKind.Punctuation;
			}
			else if (Char.IsSeparator(theChar))
			{
				return CharKind.Separator;
			}
			else if (Char.IsSurrogate(theChar))
			{
				return CharKind.Surrogate;
			}
			else if (Char.IsSymbol(theChar))
			{
				return CharKind.Symbol;
			}
			else if (Char.IsWhiteSpace(theChar))
			{
				return CharKind.Whitespace;
			}
			else
			{
				return CharKind.Unknown;
			}
		}

		public static CharKind GetCharKindInString(string theString, int charPosition)
		{
			if (Char.IsControl(theString, charPosition))
			{
				return CharKind.Control;
			}
			else if (Char.IsDigit(theString, charPosition))
			{
				return CharKind.Digit;
			}
			else if (Char.IsLetter(theString, charPosition))
			{
				return CharKind.Letter;
			}
			else if (Char.IsNumber(theString, charPosition))
			{
				return CharKind.Number;
			}
			else if (Char.IsPunctuation(theString, charPosition))
			{
				return CharKind.Punctuation;
			}
			else if (Char.IsSeparator(theString, charPosition))
			{
				return CharKind.Separator;
			}
			else if (Char.IsSurrogate(theString, charPosition))
			{
				return CharKind.Surrogate;
			}
			else if (Char.IsSymbol(theString, charPosition))
			{
				return CharKind.Symbol;
			}
			else if (Char.IsWhiteSpace(theString, charPosition))
			{
				return CharKind.Whitespace;
			}
			else
			{
				return CharKind.Unknown;
			}
		}
        #endregion

        #region "2.2 Sprawdzanie, czy znak znajduje si w okrelonym zakresie"
        public static bool IsInRange(char testChar, char startOfRange, char endOfRange)
        {
            if (testChar >= startOfRange && testChar <= endOfRange)
            {
                // znak testChar znajduje si wewntrz zakresu
                return (true);
            }
            else
            {
                // znak testChar znajduje si poza zakresem
                return (false);
            }
        }

        public static bool IsInRangeCaseInsensitive(char testChar, char startOfRange, char endOfRange)
        {
            testChar = char.ToUpper(testChar);
            startOfRange = char.ToUpper(startOfRange);
            endOfRange = char.ToUpper(endOfRange);

            if (testChar >= startOfRange && testChar <= endOfRange)
            {
                // znak testChar naley do zakresu
                return (true);
            }
            else
            {
                // znak testChar nie naley do zakresu
                return (false);
            }
        }

		public static bool IsInRangeExclusive(char testChar, char startOfRange, char endOfRange)
		{
			if (testChar > startOfRange && testChar < endOfRange)
			{
                // znak testChar naley do zakresu
				return (true);
			}
			else
			{
                // znak testChar nie naley do zakresu
				return (false);
			}
		}

		public static bool IsInRangeExclusiveCaseInsensitive(char testChar, char startOfRange, char endOfRange)
		{
			testChar = char.ToUpper(testChar);
			startOfRange = char.ToUpper(startOfRange);
			endOfRange = char.ToUpper(endOfRange);
			
			if (testChar > startOfRange && testChar < endOfRange)
			{
                // znak testChar naley do zakresu
				return (true);
			}
			else
			{
                // znak testChar nie naley do zakresu
				return (false);
			}
		}
		#endregion

        #region "2.3 Porwnywanie znakw z rozrnianiem wielkoci liter i bez niego"
        public static bool IsCharEqual(char firstChar, char secondChar)
		{
			return (IsCharEqual(firstChar, secondChar, false));
		}

		public static bool IsCharEqual(char firstChar, char secondChar, 
			bool caseSensitiveCompare)
		{
			if (caseSensitiveCompare)
			{
				return (firstChar.Equals(secondChar));
			}
			else
			{
				return (char.ToUpper(firstChar).Equals(char.ToUpper(secondChar)));
			}
		} 

		public static bool IsCharEqual(char firstChar, CultureInfo firstCharCulture, char secondChar, CultureInfo secondCharCulture)
		{
			return (IsCharEqual(firstChar, firstCharCulture, secondChar, secondCharCulture, false));
		}

		public static bool IsCharEqual(char firstChar, CultureInfo firstCharCulture, char secondChar, CultureInfo secondCharCulture, 
			bool caseSensitiveCompare)
		{
			if (caseSensitiveCompare)
			{
				return (firstChar.Equals(secondChar));
			}
			else
			{
				return (char.ToUpper(firstChar, firstCharCulture).Equals(char.ToUpper(secondChar, secondCharCulture)));
			}
		} 
		#endregion

        #region "2.4 Wyszukiwanie wszystkich wystpie znaku w cigu"
        public static int[] FindAllOccurrences(char matchChar, string source)
        {
            return (FindAllOccurrences(matchChar, source, -1, false));
        }

        public static int[] FindAllOccurrences(char matchChar, string source,
                                               int maxMatches)
        {
            return (FindAllOccurrences(matchChar, source, maxMatches, false));
        }

        public static int[] FindAllOccurrences(char matchChar, string source,
                                               bool caseSensitivity)
        {
            return (FindAllOccurrences(matchChar, source, -1, caseSensitivity));
        }

        public static int[] FindAllOccurrences(char matchChar, string source,
                                               int maxMatches, bool caseSensitivity)
        {
            List<int> occurrences = new List<int>();
            int foundPos = -1;   // -1 oznacza, e nie znaleziono znaku.
            int numberFound = 0;
            int startPos = 0;
            char tempMatchChar = matchChar;
            string tempSource = source;

            if (!caseSensitivity)
            {
                tempMatchChar = char.ToUpper(matchChar);
                tempSource = source.ToUpper();
            }

            do
            {
                foundPos = tempSource.IndexOf(matchChar, startPos);
                if (foundPos > -1)
                {
                    startPos = foundPos + 1;
                    numberFound++;

                    if (maxMatches > -1 && numberFound > maxMatches)
                    {
                        break;
                    }
                    else
                    {
                        occurrences.Add(foundPos);
                    }
                }
            } while (foundPos > -1);

            return ((int[])occurrences.ToArray());
        }

		#endregion

        #region "2.5 Wyszukiwanie wszystkich wystpie cigu znakw w innym cigu znakw"
        public static int[] FindAll(string matchStr, string searchedStr, int startPos)
        {
            int foundPos = -1;   // -1 oznacza, e cigu nie znaleziono.
            int count = 0;
            List<int> foundItems = new List<int>();

            do
            {
                foundPos = searchedStr.IndexOf(matchStr, startPos);
                if (foundPos > -1)
                {
                    startPos = foundPos + 1;
                    count++;
                    foundItems.Add(foundPos);

                    Console.WriteLine("Znaleziono podcig na pozycji: " + foundPos.ToString());
                }
            } while (foundPos > -1 && startPos < searchedStr.Length);

            return ((int[])foundItems.ToArray());
        }

        public static int[] FindAll(char MatchChar, string searchedStr, int startPos)
        {
            int foundPos = -1;   // -1 oznacza, e cigu nie znaleziono
            int count = 0;
            List<int> foundItems = new List<int>();

            do
            {
                foundPos = searchedStr.IndexOf(MatchChar, startPos);
                if (foundPos > -1)
                {
                    startPos = foundPos + 1;
                    count++;
                    foundItems.Add(foundPos);

                    Console.WriteLine("Znaleziono znak na pozycji: " + foundPos.ToString());
                }
            } while (foundPos > -1 && startPos < searchedStr.Length);

            return ((int[])foundItems.ToArray());
        }


        public static int[] FindAny(string matchStr, string searchedStr, int startPos)
        {
            int foundPos = -1;   // -1 oznacza, e cigu nie znaleziono.
            int count = 0;
            List<int> foundItems = new List<int>();

            // wczenie opcji rozrniania wielkich i maych liter
            searchedStr = searchedStr.ToUpper();
            matchStr = matchStr.ToUpper();

            do
            {
                foundPos = searchedStr.IndexOf(matchStr, startPos);
                if (foundPos > -1)
                {
                    startPos = foundPos + 1;
                    count++;
                    foundItems.Add(foundPos);

                    Console.WriteLine("Znaleziono podcig na pozycji: " + foundPos.ToString());
                }
            } while (foundPos > -1 && startPos < searchedStr.Length);

            return ((int[])foundItems.ToArray());
        }


        public static int[] FindAny(char[] matchCharArray, string searchedStr,
                            int startPos)
        {
            int foundPos = -1;   // -1 oznacza, e szukanych znakw nie odnaleziono.
            int count = 0;
            List<int> foundItems = new List<int>();

            do
            {
                foundPos = searchedStr.IndexOfAny(matchCharArray, startPos);
                if (foundPos > -1)
                {
                    startPos = foundPos + 1;
                    count++;
                    foundItems.Add(foundPos);

                    Console.WriteLine("Znaleziono znak na pozycji: " + foundPos.ToString());
                }
            } while (foundPos > -1 && startPos < searchedStr.Length);

            return ((int[])foundItems.ToArray());
        }

	    #endregion

        #region "2.6 Implementacja prostego analizatora dzielcego tekst na sowa"
        public static void SimpleTokenizer()
		{
            string equation = "1 + 2 - 4 * 5";
            string[] equationTokens = equation.Split(new char[1] { ' ' });

            foreach (string Tok in equationTokens)
                Console.WriteLine(Tok);


            string fullName1 = "Jan Domarski";
            string fullName2 = "Domarski,Jan";
            string fullName3 = "Jan P. Domarski";

            string[] nameTokens1 = fullName1.Split(new char[3] { ' ', ',', '.' });
            string[] nameTokens2 = fullName2.Split(new char[3] { ' ', ',', '.' });
            string[] nameTokens3 = fullName3.Split(new char[3] { ' ', ',', '.' });

            foreach (string tok in nameTokens1)
            {
                Console.WriteLine(tok);
            }
            Console.WriteLine("");

			foreach (string tok in nameTokens2)
			{
				Console.WriteLine(tok);
			}
			Console.WriteLine("");

			foreach (string tok in nameTokens3)
			{
				Console.WriteLine(tok);
			}
		}
		#endregion

        #region "2.7 Zarzdzanie rozrnianiem wielkich i maych liter podczas porwnywania dwch cigw znakw"
        public static void TestCompareCaseControl()
	    {
            string lowerCase = "abc";
            string upperCase = "AbC";

            //int caseSensitiveResult = string.Compare(lowerCase, upperCase, false);
            //int caseInsensitiveResult = string.Compare(lowerCase, upperCase, true);

            int caseInsensitiveResult = string.Compare(lowerCase, upperCase, StringComparison.CurrentCultureIgnoreCase);
            int caseSensitiveResult = string.Compare(lowerCase, upperCase, StringComparison.CurrentCulture);

            Console.WriteLine(caseSensitiveResult);
            Console.WriteLine(caseInsensitiveResult);
        }
	    #endregion

        #region "2.8 Porwnywanie cigu znakw z pocztkiem lub kocem innego cigu znakw"
        public static void StringBeginEndComparisons()
	    {
            string head = "str";
            string test = "strVarName";
            bool isFound = test.StartsWith(head);

            string tail = "Name";
            test = "strVarName";
            isFound = test.EndsWith(tail);
		
			head = "str";
			test = "strVarName";
			int location = string.Compare(head, 0, test, 0, head.Length, true);

			tail = "Name";
			test = "strVarName";
			location = string.Compare(tail, 0, test, (test.Length - tail.Length), tail.Length, true);
		}
	    #endregion

        #region "2.9 Wstawianie tekstu do cigu znakw"
        public static void StringInsert()
        {
            string sourceString = "Wstawiany tekst bdzie tu -><-";

            sourceString = sourceString.Insert(28, "Wstaw-To");
            Console.WriteLine(sourceString);
		
			char insertChar = '1';
			sourceString  = sourceString.Insert(28, Convert.ToString(insertChar));
			Console.WriteLine(sourceString);
		}
        #endregion

        #region "2.10 Usuwanie lub zastpowanie znakw w cigu"
        public static void RemoveReplaceChars()
        {
            string name = "Domarski, Jan";
            name = name.Remove(8, 1);
            Console.WriteLine(name);

            StringBuilder str = new StringBuilder("1234abc5678", 12);
            str.Remove(4, 3);
            Console.WriteLine(str);

            string commaDelimitedString = "100,200,300,400,500";
            commaDelimitedString = commaDelimitedString.Replace(',', ':');
            Console.WriteLine(commaDelimitedString);

            string theName = "Marii";
            string theObject = "samochd";
            string ID = "Ten <ObjectPlaceholder> jest wasnoci <NamePlaceholder>.";
            ID = ID.Replace("<ObjectPlaceholder>", theObject);
            ID = ID.Replace("<NamePlaceholder>", theName);
            Console.WriteLine(ID);

            string newName = "Jan Domarski";

            str = new StringBuilder("name = <NAME>");
            str.Replace("<NAME>", newName);
            Console.WriteLine(str.ToString());
            str.Replace('=', ':');
            Console.WriteLine(str.ToString());

            str = new StringBuilder("name1 = <FIRSTNAME>, name2 = <FIRSTNAME>");
            str.Replace("<FIRSTNAME>", newName, 7, 12);
            Console.WriteLine(str.ToString());
            str.Replace('=', ':', 0, 7);
            Console.WriteLine(str.ToString());
        }
        #endregion

        #region "2.11 Dekodowanie danych binarnych zakodowanych w formacie Base64"
        public static byte[] Base64DecodeString(string inputStr) 
		{
			byte[] encodedByteArray = Convert.FromBase64CharArray(inputStr.ToCharArray(), 0, inputStr.Length);
			return (encodedByteArray);
		}
	    #endregion

        #region "2.12 Kodowanie danych binarnych w formacie Base64"
        
        public static string Base64EncodeBytes(byte[] inputBytes) 
		{
			// Each 3 byte sequence in inputBytes must be converted to a 4 byte sequence 
			long arrLength = (long)(4.0d * inputBytes.Length / 3.0d);
			if ((arrLength  % 4) != 0) 
            {
				// increment the array length to the next multiple of 4 if it is not already divisible by 4
				arrLength += 4 - (arrLength % 4);
		}
	    
			char[] encodedCharArray = new char[arrLength];
			Convert.ToBase64CharArray(inputBytes, 0, inputBytes.Length, encodedCharArray, 0);

			return (new string(encodedCharArray));
        }
	    #endregion

        #region "2.13 Konwersja obiektu String zwrconego w formacie Byte[] do postaci String"
        public static string FromASCIIByteArray(byte[] characters)
		{
			ASCIIEncoding encoding = new ASCIIEncoding();
			string constructedString = encoding.GetString(characters);

			return (constructedString);
		}

		public static string FromUnicodeByteArray(byte[] characters)
		{
			UnicodeEncoding encoding = new UnicodeEncoding();
			string constructedString = encoding.GetString(characters);

			return (constructedString);
		}
	    #endregion

        #region "2.14 Przekazywanie cigu znakw do metody, ktra akceptuje wycznie dane typu byte[]"
        public static byte[] ToASCIIByteArray(string characters)
		{
			ASCIIEncoding encoding = new ASCIIEncoding();
			int numberOfChars = encoding.GetByteCount(characters);
			byte[] retArray = new byte[numberOfChars];

			retArray = encoding.GetBytes(characters);

			return (retArray);
		}

		public static byte[] ToUnicodeByteArray(string characters)
		{
			UnicodeEncoding encoding = new UnicodeEncoding();
			int numberOfChars = encoding.GetByteCount(characters);
			byte[] retArray = new byte[numberOfChars];

			retArray = encoding.GetBytes(characters);

			return (retArray);
		}
        #endregion

        #region "2.15 Konwersja cigw znakw na dane innych typw"
        public static void ConvertStrToVal()
        {
            string longString = "7654321";
            int actualInt = Int32.Parse(longString);    // longString = 7654321

            string dblString = "-7654.321";
            double actualDbl = Double.Parse(dblString, NumberStyles.AllowDecimalPoint |
                    NumberStyles.AllowLeadingSign);    // longString = "-7654.321

            string boolString = "true";
            bool actualBool = Boolean.Parse(boolString);    // actualBool = true

            string charString = "t";
            char actualChar = char.Parse(charString);    // actualChar = 't'

            string colorString = "niebieski";

            // Zwrmy uwag, e metoda Parse wywoana poniej zostaa zdefiniowana w obrebie typuby System.Enum, a nie Colors
            Colors actualEnum = (Colors)Colors.Parse(typeof(Colors), colorString);
            // actualEnum = niebieski
        }
        #endregion

        #region "2.16 Formatowanie danych w cigach znakw"
        public static void FormatData()
		{
            int ID = 12345;
            double weight = 12.3558;
            char row = 'Z';
            string section = "1A2C";

            string output = string.Format(@"W wierszu {2:G} i sekcji {3:G} znaleziono pozycj ID = {0:G} o wadze = {1:G}.", ID, weight, row, section);
            Console.WriteLine(output);
            output = string.Format(@"W wierszu {2:E} i sekcji {3:E} znaleziono pozycj ID = {0:N} o wadze = {1:E}.", ID, weight, row, section);
            Console.WriteLine(output);
            output = string.Format(@"W wierszu {2:E} i sekcji {3:D} znaleziono pozycj ID = {0:N} o wadze = {1:N}.", ID, weight, row, section);
            Console.WriteLine(output);
            output = string.Format(@"W wierszu {2} i sekcji {3} znaleziono pozycj ID = {0:(#####)} o wadze = {1:0000.00 kg}", ID, weight, row, section);
            Console.WriteLine(output);

            Console.WriteLine(@"W wierszu {2,-5:G} i sekcji {3,-10:G} " +
                           "znaleziono pozycj ID = {0,5:G} o wadze = {1,10:G}.",
                           ID, weight, row, section);
        }
        #endregion

        #region "2.17 Tworzenie cigu znakw rozdzielanego separatorami"
        public static void DelimitedStr()
        {
			string[] infoArray = new string[5] {"11", "12", "Wydatki", "111", "Oszczdnoci"};
			string delimitedInfo = string.Join(",", infoArray);
		}
        #endregion

        #region "2.18 Wyodrbnianie elementw z tekstu rozdzielanego separatorami"
        public static void DelimitedStrExtraction()
		{
            string delimitedInfo = "100,200,400,3,67";
            string[] discreteInfo = delimitedInfo.Split(new char[1] { ',' });

            foreach (string Data in discreteInfo)
                Console.WriteLine(Data);

		}
		#endregion

        #region "2.19 Ustawienie maksymalnej liczby znakw dla obiektw klasy StringBuilder"
        public static void MaxChars()
		{
            System.Text.StringBuilder sbMax = new System.Text.StringBuilder(10, 10);
            sbMax.Append("123456789");
            sbMax.Append("0");
        }
		#endregion

        #region "2.20 Przetwarzanie w ptli wszystkich znakw w cigu"
        public static void StringIterating()
		{
            string testStr = "abc123";
            foreach (char c in testStr)
            {
                Console.WriteLine(c.ToString());
            }

            for (int counter = 0; counter < testStr.Length; counter++)
            {
                Console.WriteLine(testStr[counter]);
            }
        }
		#endregion

        #region "2.21 Poprawa wydajnoci porwnywania cigw znakw"
        public class InternedStrCls
        {
            public static void CreateInternedStr(char[] characters)
            {
                string NonInternedStr = new string(characters);
                String.Intern(NonInternedStr);
            }

            public static void CreateInternedStr(StringBuilder strBldr)
            {
                String.Intern(strBldr.ToString());
            }

            public static void CreateInternedStr(string str)
            {
                String.Intern(str);
            }

            public static void CreateInternedStr(string[] strArray)
            {
                foreach (string s in strArray)
                {
                    String.Intern(s);
                }
            }
        }
        #endregion

        #region "Poprawa wydajnoci aplikacji wykorzystujcych klas StringBuilder"
        public static void StringBldrPerf()
		{
			StringBuilder sb = new StringBuilder(200);
			sb.Capacity = 200;
			sb.EnsureCapacity(200);
		}
		#endregion

        #region "2.23 Usuwanie znakw z pocztku i(lub) koca cigu znakw"
        public static void PruningChars()
		{
            string foo = "--TEST--";
            Console.WriteLine(foo.Trim(new char[1] { '-' }));             // Wywietla "TEST"

            foo = ",-TEST-,-";
            Console.WriteLine(foo.Trim(new char[2] { '-', ',' }));         // Wywietla "TEST"

            foo = "-TEST--";
            Console.WriteLine(foo.TrimStart(new char[1] { '-' }));        // Wywietla "TEST--"

            foo = ",-TEST-,-";
            Console.WriteLine(foo.TrimStart(new char[2] { '-', ',' })); // Wywietla "TEST-,-"

            foo = "--TEST--";
            Console.WriteLine(foo.TrimEnd(new char[1] { '-' }));          // Wywietla "--TEST"

            foo = ",-TEST-,-";
            Console.WriteLine(foo.TrimEnd(new char[2] { '-', ',' }));      // Wywietla ",-TEST"
        }
		#endregion

        #region "2.24 Sprawdzanie, czy cig znakw jest pusty bd zawiera warto Null"
        public static void TestStringForNullEmpty()
		{
			string testNull = null;
			string testEmpty = string.Empty;
			string testBlank = "";
			string testFilledIn = "abc";

			Console.WriteLine("String.IsNullOrEmpty(testNull) == " + String.IsNullOrEmpty(testNull));
			Console.WriteLine("String.IsNullOrEmpty(testEmpty) == " + String.IsNullOrEmpty(testEmpty));
			Console.WriteLine("String.IsNullOrEmpty(testBlank) == " + String.IsNullOrEmpty(testBlank));
			Console.WriteLine("String.IsNullOrEmpty(testFilledIn) == " + String.IsNullOrEmpty(testFilledIn));
		}
		#endregion

        #region "2.25 Doczanie wiersza"
        public static void AppendLine()
		{
            StringBuilder sb = new StringBuilder("Pierwszy wiersz tekstu" + Environment.NewLine);
            sb.AppendLine("Drugi wiersz tekstu");
			sb.AppendLine();
            sb.AppendLine("Czwarty wiersz tekstu");
			
			Console.WriteLine(sb.ToString());
		}
		#endregion

        #region "Kodowanie danych przekazywanych porcjami"
        public static void ConvertBlocksOfData()
		{
            // Utworzenie obiektu kodujcego.
            Encoding encoding = Encoding.UTF7;
            Encoder encoder = encoding.GetEncoder();

            // Utworzenie statycznej tablicy bajtowej.
            // Warto jej rozmiaru mona dostosowa do indywidualnych potrzeb
            // aplikacji.
            byte[] outputBytes = new byte[20];

            // Konfiguracja ptli dodajcej dane do bufora do czasu jego zapenienia
            // lub wyczerpania si danych w buforze inputBuffer.
            bool isLastBuffer = false;
            int startPos = 0;
            while (!isLastBuffer)
            {
                // Pobranie kolejnego bloku danych znakowych.
                                char[] inputBuffer = GetInputBuffer(out isLastBuffer);

               // Sprawdzenie, czy nie nastpi przepenienie tablicy bajtw.
				if ((startPos /* * 2*/ + inputBuffer.Length /* * 2*/) >= outputBytes.Length)
				{
                    Console.WriteLine("ZMIANA ROZMIARW TABLICY");
                    // Zmiana rozmiaru tablicy w celu obsuenia dodatkowych danych.
                    byte[] tempBuffer = new byte[outputBytes.Length];
					outputBytes.CopyTo(tempBuffer, 0);
					outputBytes = new byte[tempBuffer.Length * 2];
					tempBuffer.CopyTo(outputBytes, 0);
				}

                // Skopiowanie bufora wejciowego do naszego bufora byte[]
                // w miejscu, gdzie zakonczono ostatni operacj kopiowania.
				int charsUsed;
				int bytesUsed;
				bool completed;
				encoder.Convert(inputBuffer, 0, inputBuffer.Length, outputBytes, startPos /* * 2*/, inputBuffer.Length /* * 2*/, isLastBuffer, out charsUsed, out bytesUsed, out completed);

                // Inkrementacja pocztkowej pozycji w tablicy byte[]
                // od ktrej bdzie dodawany nastpny bufor wejciowy.
                startPos += inputBuffer.Length;

				Console.WriteLine("Pierwszy: charsUsed == " + charsUsed.ToString());
				Console.WriteLine("Pierwszy: bytesUsed == " + bytesUsed.ToString());
				Console.WriteLine("Pierwszy: completed == " + completed.ToString());

				//if (!completed)
				//{
				//    encoder.Convert(inputBuffer, charsUsed, inputBuffer.Length - charsUsed, outputBytes, startPos, inputBuffer.Length - charsUsed, isLastBuffer, out charsUsed, out bytesUsed, out completed);
				//	
				//    // Increment the starting position in the byte[]
				//    //    in which to add the next input buffer
				//    startPos += inputBuffer.Length;
				//
				//    Console.WriteLine("Second: charsUsed == " + charsUsed.ToString());
				//    Console.WriteLine("Second: bytesUsed == " + bytesUsed.ToString());
				//    Console.WriteLine("Second: completed == " + completed.ToString());
				//}
			}

			// Wywietlenie danych
			Console.WriteLine("isLastBuffer == " + isLastBuffer.ToString());
			foreach (byte b in outputBytes)
			{
				if (b > 0)
					Console.Write(b.ToString() + " -- ");
			}
			Console.WriteLine();
		}

        const int size = 6;    // Rozmiar danych zwracanych jako tablice typu char[]
        static int index = 0;  // Bieca pozycja wejciowego tekstu

        // Przykadowa metoda przekazujca porcjami dane  do metody wywoujcej.
        public static char[] GetInputBuffer(out bool isLastBuffer)
        {
            // Wejciowy cig znakw.
			string text = "abcdefghijklmnopqrstuvwxyz";

			char[] inputBuffer = null;

			if ((index + size) < text.Length)
			{
                // Utworzenie bufora, ktry bdzie zwrcony (nie skoczylimy).
				inputBuffer = text.ToCharArray(index, size);
				isLastBuffer = false;
			}
			else
			{
                // Utworzenie bufora, ktry bdzie zwrcony (koniec cigu wejciowego).
				inputBuffer = text.ToCharArray(index, text.Length - index);
				isLastBuffer = true;
			}

            // Inkrementacja indeksu do nastpnego bloku danych w tekcie.
			index += size;

			return (inputBuffer);
		}
		#endregion
	}
	

#region "Enums"
	public enum CharKind
	{
		Control,
		Digit,
		Letter,
		Number,
		Punctuation,	
		Separator,
		Surrogate,
		Symbol,
		Whitespace,
		Unknown
	}
	
	enum Colors
	{
		czerwony, zielony, niebieski
	}
#endregion	

}
